//---------------------------------------------------------------------
//
//---------------------------------------------------------------------

inline void c_v::m3_normalize ( void ) {
}

//---------------------------------------------------------------------
//
//---------------------------------------------------------------------

inline void c_v::m4_normalize ( void ) {

   float length, len = 0;
   length = m4_length();

   if (length == 0) return;

   len = 1.0f / length;

   v_4[0] *= len;
   v_4[1] *= len;
   v_4[2] *= len;
   v_4[3] *= len;
}

//---------------------------------------------------------------------
//
//---------------------------------------------------------------------

inline float c_v::m3_length ( void ) {
}

//---------------------------------------------------------------------
//
//---------------------------------------------------------------------

inline float c_v::m4_length ( void ) {
   double length = (v_4[0] * v_4[0]) + (v_4[1] * v_4[1]) + (v_4[2] * v_4[2]) + (v_4[3] * v_4[3]);
   return (float) sqrt(length);
}

//---------------------------------------------------------------------
//
//---------------------------------------------------------------------

inline void c_v::m_transpose ( c_v &d ) const {

   c_v t;

   t.m_16[0][0] = m_16[0][0];
   t.m_16[0][1] = m_16[1][0];
   t.m_16[0][2] = m_16[2][0];
   t.m_16[0][3] = m_16[3][0];
   t.m_16[1][0] = m_16[0][1];
   t.m_16[1][1] = m_16[1][1];
   t.m_16[1][2] = m_16[2][1];
   t.m_16[1][3] = m_16[3][1];
   t.m_16[2][0] = m_16[0][2];
   t.m_16[2][1] = m_16[1][2];
   t.m_16[2][2] = m_16[2][2];
   t.m_16[2][3] = m_16[3][2];
   t.m_16[3][0] = m_16[0][3];
   t.m_16[3][1] = m_16[1][3];
   t.m_16[3][2] = m_16[2][3];
   t.m_16[3][3] = m_16[3][3];

   d.m_set(t);
}

//---------------------------------------------------------------------
//
//---------------------------------------------------------------------

inline void c_v::m_set ( const c_v &d ) {

   m_16[0][0] = d.m_16[0][0];
   m_16[0][1] = d.m_16[0][1];
   m_16[0][2] = d.m_16[0][2];
   m_16[0][3] = d.m_16[0][3];

   m_16[1][0] = d.m_16[1][0];
   m_16[1][1] = d.m_16[1][1];
   m_16[1][2] = d.m_16[1][2];
   m_16[1][3] = d.m_16[1][3];

   m_16[2][0] = d.m_16[2][0];
   m_16[2][1] = d.m_16[2][1];
   m_16[2][2] = d.m_16[2][2];
   m_16[2][3] = d.m_16[2][3];

   m_16[3][0] = d.m_16[3][0];
   m_16[3][1] = d.m_16[3][1];
   m_16[3][2] = d.m_16[3][2];
   m_16[3][3] = d.m_16[3][3];
}

//---------------------------------------------------------------------
//
//---------------------------------------------------------------------

inline void c_v::m_identity ( void ) {

   m_16[0][0] = 1.0f;
   m_16[0][1] = 0.0f;
   m_16[0][2] = 0.0f;
   m_16[0][3] = 0.0f;

   m_16[1][0] = 0.0f;
   m_16[1][1] = 1.0f;
   m_16[1][2] = 0.0f;
   m_16[1][3] = 0.0f;

   m_16[2][0] = 0.0f;
   m_16[2][1] = 0.0f;
   m_16[2][2] = 1.0f;
   m_16[2][3] = 0.0f;

   m_16[3][0] = 0.0f;
   m_16[3][1] = 0.0f;
   m_16[3][2] = 0.0f;
   m_16[3][3] = 1.0f;
}

//---------------------------------------------------------------------
//
//---------------------------------------------------------------------

bool c_v::m_inverse ( c_v &inverse ) {

   int   i, j, k, swap;
   float t;
   float temp[4][4];

   for (i = 0; i < 4; ++i) {
      for (j = 0; j < 4; ++j) {
         temp[i][j] = m_a[i * 4 + j];
      }
   }

   inverse.m_identity();

   for (i = 0; i < 4; i++) {
      // Look for largest element in column
      swap = i;

      for (j = i + 1; j < 4; ++j) {
         if (fabs(temp[j][i]) > fabs(temp[i][i])) {
            swap = j;
         }
      }

      if (swap != i) {
         // Swap rows.
         for (k = 0; k < 4; ++k) {
            t             = temp[i][k];
            temp[i][k]    = temp[swap][k];
            temp[swap][k] = t;

            t = inverse.m_a[i * 4 + k];
            inverse.m_a[i * 4 + k] = inverse.m_a[swap * 4 + k];
            inverse.m_a[swap * 4 + k] = t;
         }
      }

      if (temp[i][i] == 0) {
         // No non-zero pivot. The matrix is singular, which shouldn't
	 // happen.  This means the user gave us a bad matrix.
         return 0;
      }

      t = temp[i][i];

      for (k = 0; k < 4; ++k) {
         temp[i][k] /= t;
         inverse.m_a[i * 4 + k] /= t;
      }

      for (j = 0; j < 4; j++) {
         if (j != i) {
            t = temp[j][i];

            for (k = 0; k < 4; k++) {
               temp[j][k] -= temp[i][k] * t;
               inverse.m_a[j * 4 + k] -= inverse.m_a[i * 4 + k] * t;
            }
         }
      }
   }
   
   return 1;
}
