//------------------------------------------------------------------;
//
//------------------------------------------------------------------;

int c_fx::m_set_fx ( void ) {

   D3DXMATRIX l_trans;
   D3DXMATRIX l_rotate;

   D3DXMatrixTranslation          ( &l_trans, 0.0f, 0.0f, 5.0f );
   D3DXMatrixRotationYawPitchRoll ( &l_rotate,
		                    D3DXToRadian(e_d3d->l_spin_x),
		                    D3DXToRadian(e_d3d->l_spin_y),
		                    0.0f );

   e_d3d->l_mat_world = l_rotate * l_trans;

   D3DXMatrixIdentity( &e_d3d->l_mat_view ); //!view/matrix

   D3DXMATRIX l_w_view_proj = e_d3d->l_mat_world * e_d3d->l_mat_view * e_d3d->l_mat_proj;
   D3DXMatrixTranspose        ( &l_w_view_proj, &l_w_view_proj );

   D3DXMATRIX l_w_view_inv = e_d3d->l_mat_world * e_d3d->l_mat_view;
   D3DXMatrixInverse          ( &l_w_view_inv, NULL, &l_w_view_inv );

   D3DXMATRIX l_world = e_d3d->l_mat_world;
   D3DXMatrixTranspose        ( &l_world, &l_world );

   c_v m2;
   // light
   m2.v4           ( 1.0f, 0.0f, -1.0f, 0.0f );
   m2.m4_normalize ();
   // eye
   m2.v3           ( 0.0f, 0.0f, -28.0f );
	
   e_d3d->l_d3d_device->SetVertexShaderConstantF (0,  l_w_view_proj, 4);	
   e_d3d->l_d3d_device->SetVertexShaderConstantF (5,  l_w_view_inv, 4);
   e_d3d->l_d3d_device->SetVertexShaderConstantF (11, l_world, 4);

   e_d3d->l_d3d_device->SetVertexShaderConstantF (9, D3DXVECTOR4(0.0f, 0.5f, 1.0f, -1.0f), 1);
   e_d3d->l_d3d_device->SetVertexShaderConstantF (4,  m2.v_4, 1);
   e_d3d->l_d3d_device->SetVertexShaderConstantF (10, m2.v_3, 1);

   return 1;
}

//------------------------------------------------------------------;
//
//------------------------------------------------------------------;

int c_fx::m_init_fx ( void ) {

   D3DVERTEXELEMENT9 l_declaration[] = 
   {
      { 0, 0,  D3DDECLTYPE_FLOAT3, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_POSITION, 0 },
      { 0, 12, D3DDECLTYPE_FLOAT3, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_NORMAL, 0 },
      { 0, 24, D3DDECLTYPE_FLOAT1, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_TEXCOORD, 0 },
      { 0, 36, D3DDECLTYPE_FLOAT1, D3DDECLMETHOD_DEFAULT, D3DDECLUSAGE_TEXCOORD, 1 },
      D3DDECL_END()
   };

   // load/create vs
   e_d3d->l_d3d_device->CreateVertexDeclaration( l_declaration, &e_d3d->l_vertex_declare );

   ID3DXBuffer *l_shader_compile = NULL;
   D3DXAssembleShaderFromFile ( "fx/fx_nv_aniso.nvv", NULL, NULL, NULL, &l_shader_compile, NULL );

   e_d3d->l_d3d_device->CreateVertexShader( (DWORD*)l_shader_compile->GetBufferPointer(),
                                            &e_d3d->l_vertex_shader );

   l_shader_compile->Release(); 

   return 1;
}

//------------------------------------------------------------------;
//
//------------------------------------------------------------------;

int c_fx::m_texture_states ( void ) {

   // material colour->tfactor

   e_d3d->l_d3d_device->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
   e_d3d->l_d3d_device->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE4X );
   e_d3d->l_d3d_device->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_TEXTURE | D3DTA_ALPHAREPLICATE);

   e_d3d->l_d3d_device->SetTextureStageState(1, D3DTSS_COLORARG1, D3DTA_CURRENT );
   e_d3d->l_d3d_device->SetTextureStageState(1, D3DTSS_COLOROP, D3DTOP_DISABLE );
   e_d3d->l_d3d_device->SetTextureStageState(1, D3DTSS_COLORARG2, D3DTA_TEXTURE |D3DTA_ALPHAREPLICATE);

   e_d3d->l_d3d_device->SetTextureStageState(1, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
   e_d3d->l_d3d_device->SetTextureStageState(1, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1);
	
   // modulate result/colour->edge texture.
   e_d3d->l_d3d_device->SetTextureStageState(2, D3DTSS_COLOROP, D3DTOP_DISABLE);

   return 1;
}
