//------------------------------------------------------------------;
// load(x)->convert to custom FVF.
//------------------------------------------------------------------;

void c_x::m_load_x_file ( const char* l_file, const DWORD l_fvf ) {

   ID3DXMesh *l_mesh_raw = NULL; // raw/mesh
   ID3DXMesh *l_mesh_opt = NULL; // opt/mesh
   ID3DXMesh *l_mesh_fvf = NULL; // mesh/conv FVF
		
   D3DXLoadMeshFromX ( const_cast<char*>(l_file),
                       D3DXMESH_SYSTEMMEM, 
                       e_d3d->l_d3d_device, 
                       NULL,
                       NULL,
                       NULL, 
                       &e_d3d->l_num_sections, 
                       &l_mesh_raw );

   l_mesh_raw->Optimize          ( D3DXMESHOPT_ATTRSORT, NULL, NULL, NULL, NULL, &l_mesh_opt );
   l_mesh_opt->GetAttributeTable ( NULL, &e_d3d->l_num_sections );

   m_safe_delete_array           ( e_d3d->l_attributes );

   e_d3d->l_attributes = new D3DXATTRIBUTERANGE[e_d3d->l_num_sections];
	
   l_mesh_opt->GetAttributeTable ( e_d3d->l_attributes, &e_d3d->l_num_sections );

   m_safe_release                ( e_d3d->l_vertex_buffer );
   m_safe_release                ( e_d3d->l_index_buffer );

   // custom format
   l_mesh_opt->CloneMeshFVF( D3DXMESH_WRITEONLY, l_fvf, e_d3d->l_d3d_device, &l_mesh_fvf );
	
   l_mesh_fvf->GetVertexBuffer   ( &e_d3d->l_vertex_buffer );
   l_mesh_fvf->GetIndexBuffer    ( &e_d3d->l_index_buffer );

   m_safe_release                ( l_mesh_raw );
   m_safe_release                ( l_mesh_opt );
   m_safe_release                ( l_mesh_fvf );

}
