/* -----------------------------------------------------------------;
 * $source   : C:\win_code\src\c\c\std\lib2d\c_tga.cpp $
 * $revision : 1.0 $
 * $author   : root@null.co.za $
 * $date     : 2004/07/16 00:00:00 $
 * $desc     : 
 * $todo     : 
 *
 * -----------------------------------------------------------------;
 */

//------------------------------------------------------------------;
//
//------------------------------------------------------------------;

h_image* f_tga_load (const char *l_file) {

   WORD l_width     = 0,
        l_height    = 0;
   byte l_length    = 0,
        l_rgb_type  = 0,
        l_bits      = 0;
   FILE *l_f_ptr    = NULL;
   int  l_channels  = 0,
	l_stride    = 0,
        l_i         = 0;

   h_image*  image = (h_image *) malloc(sizeof(h_image));

   if((l_f_ptr = fopen(l_file, "rb")) == NULL) {
      image->e++;
      return image;
   }

   fread (&l_length, sizeof(byte), 1, l_f_ptr);
   fseek (l_f_ptr,1,SEEK_CUR); 
   fread (&l_rgb_type, sizeof(byte), 1, l_f_ptr);
   fseek (l_f_ptr, 9, SEEK_CUR); 

   fread (&l_width,  sizeof(WORD), 1, l_f_ptr);
   fread (&l_height, sizeof(WORD), 1, l_f_ptr);
   fread (&l_bits,   sizeof(byte), 1, l_f_ptr);
   fseek (l_f_ptr, l_length + 1, SEEK_CUR); 

   if(l_rgb_type != TGA_RLE) {
      if(l_bits == 24 || l_bits == 32) {
         l_channels    = l_bits / 8;
         l_stride      = l_channels * l_width;
         image->data  = ((unsigned char*)malloc(sizeof(unsigned char)*l_stride*l_height));

         for(int y = 0; y < l_height; y++) {
            unsigned char *ptr_line = &(image->data[l_stride * y]);
            fread(ptr_line, l_stride, 1, l_f_ptr);
			
            for(int i = 0; i < l_stride; i += l_channels) {
               int temp        = ptr_line[i];
               ptr_line[i]     = ptr_line[i + 2];
               ptr_line[i + 2] = temp;
            }
         }
      }
      else if(l_bits == 16) {
         unsigned short pixels = 0;
         int r = 0, g = 0, b = 0;

         l_channels     = 3;
         l_stride       = l_channels * l_width;
         image->data    = ((unsigned char*)malloc(sizeof(unsigned char)*l_stride*l_height));

         for(int i = 0; i < l_width*l_height; i++) {
            fread(&pixels, sizeof(unsigned short), 1, l_f_ptr);
				
            b = (pixels & 0x1f) << 3;
            g = ((pixels >> 5) & 0x1f) << 3;
            r = ((pixels >> 10) & 0x1f) << 3;
				
            image->data[i * 3 + 0] = r;
            image->data[i * 3 + 1] = g;
            image->data[i * 3 + 2] = b;
         }
      }else
         return image;
   }else{ // rle,
      byte rle_id       = 0;
      int  colors_read  = 0;
      l_channels        = l_bits / 8;
      l_stride          = l_channels * l_width;

      image->data       = ((unsigned char*)malloc(sizeof(unsigned char)*l_stride*l_height));
      byte *ptr_colors  = ((byte*)malloc(sizeof(byte)*l_channels));

      while(l_i < l_width*l_height) {
         fread(&rle_id, sizeof(byte), 1, l_f_ptr);

         if(rle_id < 128) {
            rle_id++;
            while(rle_id) {
               fread(ptr_colors, sizeof(byte) * l_channels, 1, l_f_ptr);

               image->data[colors_read + 0] = ptr_colors[2];
               image->data[colors_read + 1] = ptr_colors[1];
               image->data[colors_read + 2] = ptr_colors[0];

               if(l_bits == 32) image->data[colors_read + 3] = ptr_colors[3];
               l_i++;
               rle_id--;
               colors_read += l_channels;
            }
         }else{
            rle_id -= 127;
            fread (ptr_colors, sizeof(byte) * l_channels, 1, l_f_ptr);

            while(rle_id) {
               image->data[colors_read + 0] = ptr_colors[2];
               image->data[colors_read + 1] = ptr_colors[1];
               image->data[colors_read + 2] = ptr_colors[0];

               if(l_bits == 32) image->data[colors_read + 3] = ptr_colors[3];
               l_i++;
               rle_id--;
               colors_read += l_channels;
            }
         }
      }
   }
   fclose(l_f_ptr);

   image->b = l_bits;
   image->c = l_channels;
   image->x = l_width;
   image->y = l_height;

   return image;
}
