@echo off
echo "|----------------------|"
echo "|compile file :        |"
echo "|----------------------|"
echo "|1. libimg [cpp]       |"
echo "|2. clean              |"
echo "|3. update             |"
echo "|4. exit               |"
echo "|----------------------|"
choice
if errorlevel 4 goto EXIT
if errorlevel 3 goto UPDATE
if errorlevel 2 goto CLEAN
if errorlevel 1 goto BUILD

:BUILD
echo.
echo.------------------------*
echo.Compiling...
echo.------------------------*
echo.

    @cl /GX /c c_main.cpp

echo.
if not errorlevel 0 goto ERROR
if     errorlevel 0 goto ASM

:ASM
echo.
echo.------------------------*
echo.Assembling...
echo.------------------------*
echo.

    @ml /c /Zi /coff /Cx /Cp g_lib.asm

echo.
if not errorlevel 0 goto ERROR
if     errorlevel 0 goto LINK

:LINK
echo.
echo.------------------------*
echo.Linking...
echo.------------------------*
echo.

    @link -lib /nologo /out:libimg.lib c_main.obj g_lib.obj
    @link /noentry /opt:noref /defaultlib:winmm.lib opengl32.lib glu32.lib glaux.lib kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib lib\libstr.lib lib\libsys.lib lib\jpeg.lib /out:out.exe c_main.obj g_lib.obj

if not errorlevel 0 goto ERROR
if     errorlevel 0 goto EXIT

:UPDATE
echo.
echo.------------------------*
echo.Updating...
echo.------------------------*
echo.

   @copy lib\libimg.lib ..\..\..\..\born\lib\

echo.
if not errorlevel 0 goto ERROR
if     errorlevel 0 goto EXIT

:CLEAN
echo.
echo.------------------------*
echo.Cleaning...
echo.------------------------*
echo.
    del libimg.lib
rem del *.res
    del *.obj
if not errorlevel 0 goto ERROR
if     errorlevel 0 goto EXIT

:ERROR
echo.
echo There was an error compiling.
echo Exiting...
echo.
pause

:EXIT
rem del *.res
    del *.obj
    @copy libimg.lib lib\
    del *.lib

