// ----------------------------------------------------------------------------------;
// michael.mill@metacom.net --- (05/10/2018)
//
// https://blog.scalyr.com/2018/07/getting-started-quickly-c-logging/
// http://www.needfulsoftware.com/Boost/Log
// https://objectcomputing.com/resources/publications/sett/may-2016-boostlog-library
// http://torjo.com/log2/doc/html/getting_started.html
//
// http://gernotklingler.com/blog/simple-customized-logger-based-boost-log-v2/
// http://torjo.com/log2/doc/html/common_scenarios.html
// 
// 

#include <iostream>

#include <boost/log/core.hpp>
#include <boost/log/trivial.hpp>
#include <boost/log/expressions.hpp>
#include <boost/log/utility/setup/file.hpp>
#include <boost/log/utility/setup/common_attributes.hpp>

namespace logging  = boost::log;
namespace keywords = boost::log::keywords;

void load_logging() {

    logging::register_simple_formatter_factory<logging::trivial::severity_level, char>("Severity");

    logging::add_file_log(
        keywords::auto_flush = true,
        keywords::file_name  = log_file, //"ipset_t.log",
        keywords::format     = "[%TimeStamp%] [%ThreadID%] [%Severity%] [%ProcessID%] [%LineID%] %Message%",
        keywords::open_mode  = std::ios::out | std::ios::app
    );

    logging::core::get()->set_filter
    (
      //logging::trivial::severity >= logging::trivial::info
        logging::trivial::severity >= logging::trivial::debug
    );

    logging::add_common_attributes();
}

