// ----------------------------------------------------------------------------------;
// michael.mill@metacom.net --- (05/10/2018)
//

#include <iostream>
#include <string>
#include <set>
#include <sstream>
#include <exception>
#include <fstream>

#include <boost/config.hpp>
#include <boost/program_options/detail/config_file.hpp>
#include <boost/program_options/parsers.hpp>

namespace pod = boost::program_options::detail;

int load_config () {  

    BOOST_LOG_TRIVIAL(info) << "[function_name:load_config() : initial startup : " << config_file << ")]";

    std::ifstream config(config_file);

    if(!config) {
        std::cerr << "error, - std::ifstream config failure" << std::endl;
        return 1;
    }

    std::set<std::string> options;
    std::map<std::string, std::string> parameters;
    options.insert("*");
    
    try {

        for (pod::config_file_iterator i(config, options), e ; i != e; ++i) {
            parameters[i->string_key] = i->value[0];
        }

        BOOST_LOG_TRIVIAL(info) << "[function_name:load_config() : setup values : (section, threads, etc)]";

        enable_logging = std::stoi (parameters["section.enable_logging"]);
        enable_daemon  = std::stoi (parameters["section.enable_daemon"]);
        num_of_threads = std::stoi (parameters["section.num_of_threads"]);
        timeout_value  = std::stoi (parameters["section.timeout_value"]);
        port_to_use    = std::stoi (parameters["section.port_to_use"]);
        sleep_for      = std::stoi (parameters["section.sleep_for"]);
      //log_file       = parameters["section.log_file"];
        ip_to_use      = parameters["section.ip_to_use"];
    }
    catch(std::exception& e) {
        std::cerr << "Exception (load_config) : " << e.what() << std::endl;
    }
    return 1;
}
