// ----------------------------------------------------------------------------------;
// michael.mill@metacom.net --- (03/08/2018)

#ifndef _IPSET_T_H
#define _IPSET_T_H

#include <cstdlib>
#include <iostream>

#include <boost/asio.hpp>
#include <boost/algorithm/string.hpp>
#include <boost/regex.hpp>
#include <boost/chrono.hpp>
#include <boost/thread/thread.hpp> 

#include <iostream>
#include <fstream>
#include <thread>
#include <vector>
#include <algorithm>

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <syslog.h>

int          enable_logging;
int          enable_daemon;
int          num_of_threads;
int          port_to_use;
std::string  ip_to_use;
std::string  log_file = "ipset_t.log";
std::string  config_file = "ipset_t.ini";
int          timeout_value;
int          sleep_for;

int          connection_count = 0;
bool         request_conforms = false;

std::string  remote_ip;

#include <ipset_t_log.h>
#include <ipset_t_config.h>
#include <ipset_t_conntrack.h>
#include <ipset_t_ipset.h>

// ----------------------------------------------------------------------------------;

#define MAX_STRING 1024
#define LESS_STRING 128

#define RUNNING_DIR "/tmp"
#define LOCK_FILE   "daemond.lock"
#define LOG_FILE    "/var/log/ipset-api.error.log"

//using boost::asio::ip::udp;
using     boost::asio::ip::tcp;
typedef   boost::shared_ptr<tcp::socket> socket_ptr;
const int max_length = 1024;

class ipset_t {

    public :

              ipset_t             (void) { };
             ~ipset_t             (void) { };

        void  server_t            (boost::asio::io_service& io_service, std::string ip, short port, int num_threads);
        void  thread_t            (void);
        int   set_cmd_t           (int argc, char** argv);
        void  log_message_t       (char *filename, char *message);
        char* time_stamp_t        (char *timestamp);
        int   set_config_parser_t (char* data_t);

        void  server_start_t      ();
        void  server_run_t        (int j);

    private :
    protected :
};

#endif
