/* -----------------------------------------------------------------;
 * $source   : / $
 * $revision : 1.0 $
 * $author   : wyr@null.co.za $
 * $date     : 2014/01/04 12:28:00 SAST $
 * $desc     : $
 * $log      : $
 *
 * -----------------------------------------------------------------;
 */

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <assert.h>
#include <string.h>
#include <stdlib.h>
#include <sqlite3.h> 
#include <time.h>       /* clock_t, clock, CLOCKS_PER_SEC */
#include <math.h>       /* sqrt */

#define        MAX_STRING 256

char           buf_a[MAX_STRING];
char*          buf_b;
char*          l_search_term;

//------------------------------------------------------------------;
// char/by/char
//------------------------------------------------------------------;

int mstrncmp(const char *s1, 
             const char *s2, 
             size_t      n) {

// printf ("(%s) - (%s)\n", s1, s2);

   for ( ; n > 0; s1++, s2++, n--) {

	if (*s1 != *s2) {

	   return ( (*(unsigned char *) s1 < *(unsigned char *) s2) ? -1 : +1);

   	}else if (*s1 == '\0') {

         return 0;
      }
   }
   return 0;
}

//------------------------------------------------------------------;
//
//------------------------------------------------------------------;

char *
mstrstr(const char *in, const char *str)
{
    char c;
    size_t len;

    c = *str++;
    if (!c)
        return (char *) in;

    len = strlen(str);

  //printf ("(%s) - (%s)\n", in, str);

    do {

  //printf ("(%s) - (%s)\n", in, str);

        char sc;

        do {
            sc = *in++;
            if (!sc)
                return (char *) 0;
        } while (sc != c);
    } while (mstrncmp(in, str, len) != 0);

    return (char *) (in - 1);
}

//------------------------------------------------------------------;
//
//------------------------------------------------------------------;

int frequency_of_primes (int n) {

  int i, j;
  int freq = n - 1;

  for (i = 2; i <= n; i++) {
     for (j = sqrt(i); j > 1 ; j--) {
        if (i % j == 0) {
           freq--;
           break;
        }
     }
  }
  return freq;
}

//------------------------------------------------------------------;
//
//------------------------------------------------------------------;

int instr (int   start,
           char* str,
           char* search) {

   int z = 0,  f = 0;

   if (start < 0) {

      return -1;

   }else{

      memset(&buf_a, 0, sizeof(buf_a));

      for(f = 0; f < strlen(str) - start; f++) {
         buf_a[f] = str[f + start];
       //buf_a[f] = str[f];
      }
      buf_a[f + 1] = '\0';

      z = (mstrstr(buf_a, search) - buf_a + 1) + start;

      if(z >= start) {
         return z;
      }else{
         return -1;
      }
   }
}

//--------------------------------------------------------------------------;
//
//--------------------------------------------------------------------------;

static int m_function_callback (void  *l_not_used, 
                                int    argc, 
                                char **argv, 
                                char **l_column_name) {

    int i;

    for ( i = 0; i < argc; i++) {

        char* j_search_term = (char*) malloc (64000);
        char* j_data        = (char*) malloc (64000);

        //printf("(%s)\n", argv[i]);

        sprintf (j_search_term, "%s", l_search_term);
        sprintf (j_data, "%s", argv[i]);

        if (instr(0, j_data, j_search_term) != -1) {
           printf ("[%s]\n", j_search_term);
        }else{
           printf("(%s)\n", argv[i]);
        }

      //printf("%s = %s\n", l_column_name[i], argv[i] ? argv[i] : "NULL");

    }

    printf("\n");

    return 0;
}

//--------------------------------------------------------------------------;
//
//--------------------------------------------------------------------------;

int sql (int    argc, 
         char **argv, 
         char **envp) {

	sqlite3 *l_database;
	char    *l_error_message = 0;
	int      l_result;
            l_search_term = (char*) malloc (64000);

   l_search_term = argv[3];
   //printf ("%i\n", argc);

	if( argc != 4 ) {
		fprintf (stderr, "usage : %s DATABASE SQL-STATEMENT\n", argv[0]);
		exit    (1);
	}

	l_result = sqlite3_open(argv[1], &l_database);

	if( l_result ) {
		fprintf       (stderr, "Can't open database : %s\n", sqlite3_errmsg(l_database));
		sqlite3_close (l_database);
		exit          (1);
	}

  //printf (argv[2]);

	l_result = sqlite3_exec(l_database, argv[2], m_function_callback, 0, &l_error_message);

	if( l_result != SQLITE_OK ) {
		fprintf       (stderr, "SQL error : %s\n", l_error_message);
		sqlite3_free  (l_error_message);
	}
	sqlite3_close(l_database);

	return 0;
}

//--------------------------------------------------------------------------;
//
//--------------------------------------------------------------------------;

int main (int    argc, 
          char **argv, 
          char **envp) {

   clock_t t;
   int     f;
   t = clock();

   sql (argc, argv, envp);

   /**
      remove below to see larger clock/cycle execution
   **/

   f = frequency_of_primes (99999);

   t = clock() - t;
 //printf ("It took me %d clicks (%f seconds).\n", t, ((float)t)/CLOCKS_PER_SEC);

   return 0;
}
