/* -----------------------------------------------------------------;
 * $source   : next development / $
 * $revision : 1.0 $
 * $author   : wyr@null.co.za $
 * $date     : 2023/12/09 00:41:00 SAST $
 * $desc     : $
 * $log      : $
 *
 * -----------------------------------------------------------------;
 */
 
 #include "../inc/next_t.h"

int append_report_to_file (std::string str_to_append)
{
	std::ofstream of;

	of.open(log_file, std::ios_base::app);
	
	of << boost::posix_time::second_clock::local_time() << " " << str_to_append << std::endl; 
	
	return 0;
}

int next_load_configuration (int c,
							 std::string s1,
							 std::string s2,
							 std::string s3)
{
    using boost::property_tree::ptree;   
	
    try 
	{
		boost::property_tree::ptree pt;
		boost::property_tree::ini_parser::read_ini(config_file, pt);
		
		next_mail_host            = pt.get<std::string>("section.user_mail_host");
		next_mail_username        = pt.get<std::string>("section.user_mail_username");
		next_mail_password        = pt.get<std::string>("section.user_mail_password");
		
		next_ssh_host             = pt.get<std::string>("section.user_ssh_host");
		next_ssh_username         = pt.get<std::string>("section.user_ssh_username");
		next_ssh_password         = pt.get<std::string>("section.user_ssh_password");
		
		next_file_local_location  = pt.get<std::string>("section.user_file_local_location");
		next_file_remote_location = pt.get<std::string>("section.user_file_remote_location");
		
		append_report_to_file ("[log] - Basic configuration updated.");
		
		int rslt = c;

        if (rslt > 0)
		{			
			switch(rslt) 
			{
				case 1 :
				
					next_mail_host            = s1;
					next_mail_username        = s2;
					next_mail_password        = s3;
				
				break;
				case 2 :
				
					next_ssh_host             = s1;
					next_ssh_username         = s2;
					next_ssh_password         = s3;
					
				break;
				case 3 :
				
					next_file_local_location  = s1;
					next_file_remote_location = s2;
					
				break;
			}
			
			ptree pt;
			
			pt.put("section.user_mail_host", next_mail_host);
			pt.put("section.user_mail_username", next_mail_username);
			pt.put("section.user_mail_password", next_mail_password);
		
			pt.put("section.user_ssh_host", next_ssh_host);
			pt.put("section.user_ssh_username", next_ssh_username);
			pt.put("section.user_ssh_password", next_ssh_password);
		
			pt.put("section.user_file_local_location", next_file_local_location);
			pt.put("section.user_file_remote_location", next_file_remote_location);

			write_ini (config_file, pt);
			
			std::cout << "Configuration updated!" << std::endl;
			
			append_report_to_file ("[log] - Configuration updated!");
			
		}		
    }
    catch(std::exception& e) 
	{
        std::cerr << "Exception (next_load_configuration) : " << e.what() << std::endl;
    }
    return 1;
}

void get_file_list(const std::string& path)
{
    if (!path.empty())
    {
        namespace fs = boost::filesystem;

		fs::path apk_path(path);
		
		std::cout << path << std::endl;
		
        fs::recursive_directory_iterator end;

        for (fs::recursive_directory_iterator i(apk_path); i != end; ++i)
        {
            const fs::path cp = (*i);
			std::string ext = boost::filesystem::extension(cp);	
		
		    if (ext.compare(".pst") == 0)
			{
				boost::filesystem::path p(cp);
				std::string v = p.string();
			
				v.erase(remove(v.begin(), v.end(), '\"' ), v.end());
				
				//std::cout << v << std::endl;
				//std::cout << p.filename().string() << std::endl;
							
				file_list_local.push_back(v);
				file_list_remote.push_back(next_file_remote_location + p.filename().string());	

				pst_file_found = true;
			}
        }
    }
}

static void fltk_dialog_setup_ssh_callback (Fl_Button *b, void * data)
{
	append_report_to_file ("[log] - fltk_dialog_setup_ssh_callback() - SSH init!");
	
	std::string s1 = fltk_dialog_setup_ssh_inp_1->value();
	std::string s2 = fltk_dialog_setup_ssh_inp_2->value();
	std::string s3 = fltk_dialog_setup_ssh_inp_3->value();
	
	next_load_configuration (2, s1, s2, s3);
	
    Fl::handle(FL_CLOSE, (Fl_Window*) data);	
}

void fltk_dialog_setup_ssh ()
{
	append_report_to_file ("[log] - fltk_dialog_setup_ssh() - SSH dialog started");
		
    Fl_Box *fltk_dialog_setup_ssh_box_1 = new Fl_Box(170, 0, 30, 40, "Setup SSH Credentials");
    fltk_dialog_setup_ssh_box_1->labelsize(14);
	
	Fl_Window* w = new Fl_Window(400, 160, "Setup SSH");

    fltk_dialog_setup_ssh_inp_1 = new Fl_Input (120, 35, 245, 20, "SSH host");
    fltk_dialog_setup_ssh_inp_2 = new Fl_Input (120, 60, 245, 20, "SSH username");
    fltk_dialog_setup_ssh_inp_3 = new Fl_Input (120, 85, 245, 20, "SSH password");
	
	Fl_Button * fltk_dialog_setup_ssh_sav_1 = new Fl_Button (10, 120, 150, 30, "Save information");
	
	fltk_dialog_setup_ssh_inp_1->static_value (next_ssh_host.c_str());
	fltk_dialog_setup_ssh_inp_2->static_value (next_ssh_username.c_str());
	fltk_dialog_setup_ssh_inp_3->static_value (next_ssh_password.c_str());
	
	w->add (fltk_dialog_setup_ssh_inp_1);
	w->add (fltk_dialog_setup_ssh_inp_2);
	w->add (fltk_dialog_setup_ssh_inp_3);	
	w->add (fltk_dialog_setup_ssh_sav_1);
	w->add (fltk_dialog_setup_ssh_box_1);
	
    fltk_dialog_setup_ssh_sav_1->callback((Fl_Callback*)fltk_dialog_setup_ssh_callback, (void*)w);
	
	w->set_modal();
	w->show();	
	
	while (w->shown()) Fl::wait();
}
static void fltk_dialog_setup_mail_callback (Fl_Button *b, void * data)
{
	append_report_to_file ("[log] - fltk_dialog_setup_mail_callback() - Mail init!");
	
	std::string s1 = fltk_dialog_setup_mail_inp_1->value();
	std::string s2 = fltk_dialog_setup_mail_inp_2->value();
	std::string s3 = fltk_dialog_setup_mail_inp_3->value();
	
	next_load_configuration (1, s1, s2, s3);
	
    Fl::handle(FL_CLOSE, (Fl_Window*) data);	
}

void fltk_dialog_setup_mail ()
{
	append_report_to_file ("[log] - fltk_dialog_setup_mail() - Mail dialog started");
		
    Fl_Box *fltk_dialog_setup_mail_box_1 = new Fl_Box(170, 0, 30, 40, "Setup Mail Credentials");
    fltk_dialog_setup_mail_box_1->labelsize(14);
	
	Fl_Window* w = new Fl_Window(400, 160, "Setup Mail");

    fltk_dialog_setup_mail_inp_1 = new Fl_Input (120, 35, 245, 20, "Mail host");
    fltk_dialog_setup_mail_inp_2 = new Fl_Input (120, 60, 245, 20, "Mail username");
    fltk_dialog_setup_mail_inp_3 = new Fl_Input (120, 85, 245, 20, "Mail password");
	
	Fl_Button * fltk_dialog_setup_mail_sav_1 = new Fl_Button (10, 120, 150, 30, "Save information");
	
	fltk_dialog_setup_mail_inp_1->static_value (next_mail_host.c_str());
	fltk_dialog_setup_mail_inp_2->static_value (next_mail_username.c_str());
	fltk_dialog_setup_mail_inp_3->static_value (next_mail_password.c_str());
	
	w->add (fltk_dialog_setup_mail_inp_1);
	w->add (fltk_dialog_setup_mail_inp_2);
	w->add (fltk_dialog_setup_mail_inp_3);	
	w->add (fltk_dialog_setup_mail_sav_1);
	w->add (fltk_dialog_setup_mail_box_1);
	
    fltk_dialog_setup_mail_sav_1->callback((Fl_Callback*)fltk_dialog_setup_mail_callback, (void*)w);
	
	w->set_modal();
	w->show();	
	
	while (w->shown()) Fl::wait();
}

static void fltk_dialog_setup_user_callback (Fl_Button *b, void * data)
{
	append_report_to_file ("[log] - fltk_dialog_setup_user_callback() - User init!");
		
	std::string s1 = fltk_dialog_setup_user_inp_1->value();
	std::string s2 = fltk_dialog_setup_user_inp_2->value();
	
	next_load_configuration (3, s1, s2, "");
	
    Fl::handle(FL_CLOSE, (Fl_Window*) data);	
}

void fltk_dialog_setup_user ()
{
	append_report_to_file ("[log] - fltk_dialog_setup_user() - User dialog started");
		
    Fl_Box *fltk_dialog_setup_user_box_1 = new Fl_Box(170, 0, 30, 40, "Setup User Information");
    fltk_dialog_setup_user_box_1->labelsize(14);
	
	Fl_Window* w = new Fl_Window(400, 160, "Setup User");
	
    fltk_dialog_setup_user_inp_1 = new Fl_Input (120, 35, 245, 20, "User path");
    fltk_dialog_setup_user_inp_2 = new Fl_Input (120, 60, 245, 20, "Remote path");
	
	Fl_Button * fltk_dialog_setup_user_sav_1 = new Fl_Button (10, 120, 150, 30, "Save information");
	
	fltk_dialog_setup_user_inp_1->static_value (next_file_local_location.c_str());
	fltk_dialog_setup_user_inp_2->static_value (next_file_remote_location.c_str());
	
	w->add (fltk_dialog_setup_user_inp_1);
	w->add (fltk_dialog_setup_user_inp_2);
	//w->add (inp_3);	
	w->add (fltk_dialog_setup_user_sav_1);
	w->add (fltk_dialog_setup_user_box_1);
	
    fltk_dialog_setup_user_sav_1->callback((Fl_Callback*)fltk_dialog_setup_user_callback, (void*)w);
	
	w->set_modal();
	w->show();	
	
	while (w->shown()) Fl::wait();
}

static void fltk_menu_callback (Fl_Widget *w, void *) 
{
  Fl_Menu_Bar *bar = (Fl_Menu_Bar*)w;				// Get the menubar widget
  const Fl_Menu_Item *item = bar->mvalue();			// Get the menu item that was picked

  char ipath[256]; bar->item_pathname(ipath, sizeof(ipath));	// Get full pathname of picked item

  fprintf(stderr, "callback: You picked '%s'", item->label());	// Print item picked
  fprintf(stderr, ", item_pathname() is '%s'", ipath);		// ..and full pathname

  if ( item->flags & (FL_MENU_RADIO|FL_MENU_TOGGLE) ) {		// Toggle or radio item?
    fprintf(stderr, ", value is %s", item->value()?"on":"off");	// Print item's value
  }
  fprintf(stderr, "\n");
  if ( strcmp(item->label(), "SSH") == 0 ) { fltk_dialog_setup_ssh (); }
  if ( strcmp(item->label(), "Mail") == 0 ) { fltk_dialog_setup_mail (); }
  if ( strcmp(item->label(), "User") == 0 ) { fltk_dialog_setup_user (); }
  if ( strcmp(item->label(), "&Quit") == 0 ) { exit(0); }
}

static void fltk_menu_callbac_sav_1(Fl_Button *b, void*) // The callback function
{
    std::string v = fltk_menu_inp_1->value();
	
	fltk_menu_inp_1->static_value ("Searching...");
	
	std::cout << "Searching..." << std::endl;
	
	get_file_list (next_file_local_location);
	
	append_report_to_file ("[log] - get_file_list() - Search and index all PST files.");
	
	if (pst_file_found) 
	{
		std::cout << "Transfer..." << std::endl;
			
		network_client (next_ssh_host,
						next_ssh_username,
						next_ssh_password,
						next_file_local_location,
						next_file_remote_location);
						
		fltk_menu_inp_1->static_value ("Transfer complete!");
		
		append_report_to_file ("[log] - network_client() - Network transfer complete!");
	}
	else
	{
	    fltk_menu_inp_1->static_value ("No .PST files found!");
    }		
}

int next_fltk_setup_gui_environment (int    argc,
                                     char * argv [],
		                             char * envp [])
{
	append_report_to_file ("[log] - next_fltk_setup_gui_environment() - Setup GUI");
			
    Fl::scheme("gtk+");
  
    Fl_Window *fltk_window = new Fl_Window (350, 180, "next development");
    Fl_Menu_Bar *fltk_menu = new Fl_Menu_Bar(0,0,400,25);
	
    fltk_menu->add("&Setup/User",  "^z", fltk_menu_callback);
    fltk_menu->add("&Setup/Mail",  "^s", fltk_menu_callback);
    fltk_menu->add("&Setup/SSH",  "^f", fltk_menu_callback);
    fltk_menu->add("&Setup/&Quit",  "^q", fltk_menu_callback);

    fltk_menu_inp_1 = new Fl_Input (90, 35, 245, 20, "Install status");
	fltk_menu_sav_1 = new Fl_Button (10, 65, 100, 30, "Start ...");
	
    fltk_window->add (fltk_menu_inp_1);
    fltk_window->add (fltk_menu_sav_1);
	
    fltk_menu_sav_1->callback((Fl_Callback*)fltk_menu_callbac_sav_1, (void*)fltk_window);
	
    fltk_window->end();
    fltk_window->show(argc, argv);
  
    return Fl::run();
}
 
int main (int    argc,
          char * argv [],
		  char * envp [])
{
	next_load_configuration (0, "", "", "");
	next_fltk_setup_gui_environment (argc, argv, envp);
}